implementation module directory_structure;

/* Directory structure:
**
** There's is a root-directory called 'Dynamics'. This directory
** contains the following file:
** - DynamicLinker.exe
**
** And the following subdirectories:
** - libraries
** - lazy dynamics
** - conversion
** - utilities
*/
import StdEnv;
import Directory;
import StdMaybe;
from StdDynamicLowLevelInterface import build_code_lib_name;
import ExtFile;

// Predefined directories (w.r.t. root-directory):
DS_LIBRARIES_DIR		:== "libraries";
DS_LAZY_DYNAMICS_DIR	:== "lazy dynamics";
DS_CONVERSION_DIR		:== "conversion";
DS_UTILITIES_DIR		:== "utilities";

ds_generate_library_name :: !String !String !*env -> (!String,!*env) | FileSystem env;
ds_generate_library_name application_name dynamic_linker_path files
	# (_,files)
		= ds_create_directory DS_LIBRARIES_DIR dynamic_linker_path files;
	= ds_generate_unique_name (build_code_lib_name application_name) DS_LIBRARIES_DIR dynamic_linker_path files;
	
ds_generate_unique_name application_name dir dynamic_linker_path files
	# (name,extension)
		= ExtractPathFileAndExtension application_name;
		
	# base_path_name
		= dynamic_linker_path +++ "\\" +++ dir +++ "\\" +++ name;
	= gen_unique_name 0 base_path_name extension files;
where {
	gen_unique_name i base_path_name extension files
		# path_name
			= base_path_name +++ "_" +++ toString i +++ "c." +++ extension;
		# ((ok,path),files)
			= pd_StringToPath path_name files;
		| not ok
			= abort "gen_unique_name: could not convert to path";
		
		# ((dir_error,_),files)
			= getFileInfo path files;
		| dir_error == DoesntExist
			= (path_name,files);
			
		= gen_unique_name (inc i) base_path_name extension files;
};
	
// auxillary functions; create a directory
ds_create_directory directory dynamic_linker_path files
	#! directory_to_be_created
		= dynamic_linker_path +++ "\\" +++ directory;
	#! ((ok,path),files)
		= pd_StringToPath directory_to_be_created files;
	| not ok
		= (Just directory_to_be_created,files);
		
	#! (_,files)
		= createDirectory path files;
	= (Nothing,files);

// append to file name
ds_append_to_file_name suffix path_name_extension 
	# (path_name,extension)
		= ExtractPathFileAndExtension path_name_extension;
	= path_name +++ suffix +++ extension;